<?php
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Pagination Function
 * Created by CMSMasters
 * 
 */


function pagination() {
	global $wp_query;
	
	
	$format = '?paged=%#%';
	
	
	if (get_query_var('paged')) {
		$current = get_query_var('paged');
	} elseif (get_query_var('page')) {
		$current = get_query_var('page');
		
		$format = '/page/%#%';
	} else {
		$current = 1;
	}
	
	
	$pagination = array( 
		'base' => str_replace(999999999, '%#%', esc_url(get_pagenum_link(999999999))), 
		'format' => $format, 
		'total' => $wp_query->max_num_pages, 
		'current' => $current, 
		'show_all' => false, 
		'end_size' => 1, 
		'mid_size' => 2, 
		'prev_next' => true, 
		'prev_text' => __('&lt;', 'cmsmasters'), 
		'next_text' => __('&gt;', 'cmsmasters'), 
		'type' => 'list', 
		'add_args' => false, 
		'add_fragment' => '' 
	);
	
	
	if (get_query_var('s')) {
		$pagination['add_args'] = array( 
			's' => get_query_var('s') 
		);
	}
	
	
	echo paginate_links($pagination);
}

