<?php 
/**
 * @package WordPress
 * @subpackage Newlife
 * @since Newlife 1.0
 * 
 * Templates Post Type
 * Created by CMSMasters
 * 
 */


class Templates {
	function Templates() { 
		$template_labels = array( 
			'name' => __('Templates', 'cmsmasters'), 
			'singular_name' => __('Templates', 'cmsmasters'), 
			'add_new' => __('Add New', 'cmsmasters'), 
			'all_items' => __('All Templates', 'cmsmasters'), 
			'add_new_item' => __('Add New Template', 'cmsmasters'), 
			'edit_item' => __('Edit Template', 'cmsmasters'), 
			'new_item' => __('New Template', 'cmsmasters'), 
			'view_item' => __('View Template', 'cmsmasters'), 
			'search_items' => __('Search Templates', 'cmsmasters'), 
			'not_found' => __('No Templates found', 'cmsmasters'), 
			'not_found_in_trash' => __('No Templates found in Trash', 'cmsmasters'), 
			'menu_name' => __('Templates', 'cmsmasters') 
		);
		
		$template_args = array( 
			'labels' => $template_labels, 
			'public' => true, 
			'menu_position' => 53, 
			'capability_type' => 'post', 
			'hierarchical' => false, 
			'supports' => array( 
				'title', 
				'editor', 
				'revisions', 
				'page-attributes' 
			), 
			'query_var' => 'content_template', 
			'has_archive' => true, 
			'show_ui' => true, 
			'_builtin' => false, 
			'_edit_link' => 'post.php?post=%d', 
			'rewrite' => array( 
				'slug' => 'content_template', 
				'with_front' => true 
			) 
		);
		
		register_post_type('content_template', $template_args);
		
		add_filter('manage_edit-template_columns', array(&$this, 'edit_columns'));
		add_filter('manage_edit-template_sortable_columns', array(&$this, 'edit_sortable_columns'));
		
		flush_rewrite_rules(false);
		
		add_action('manage_posts_custom_column', array(&$this, 'custom_columns'));
	}
	
	function edit_columns($columns) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __('Title', 'cmsmasters'),
			'tl_description' => __('Description', 'cmsmasters'),
			'menu_order' => __('Order', 'cmsmasters')
		);
		
		return $columns;
	}
	
	function custom_columns($column) {
		switch ($column) {
			case 'tl_description':
				if (has_excerpt() || get_the_content() != '') {
					theme_excerpt(20);
				} else {
					echo '<em>' . __('No Description', 'cmsmasters') . '</em>';
				}
				
				break;
			case 'menu_order':
				$custom_post = get_post(get_the_ID());
				$custom = $custom_post->menu_order;
				
				echo $custom;
				
				break;
		}
	}
	
	function edit_sortable_columns($columns) {
		$columns['menu_order'] = 'menu_order';
		
		return $columns;
	}
}


function TemplatesInit() {
	global $tt;
	
	
	$tt = new Templates();
}


add_action('init', 'TemplatesInit');

