<?php 
/**
 * @package WordPress
 * @subpackage Medicure
 * @since Medicure 1.0
 * 
 * Admin Panel Services Options
 * Created by CMSMasters
 * 
 */


function cmsms_options_services_tabs() {
	$tabs = array();
	
	$tabs['s_page'] = __('Services', 'cmsmasters');
	$tabs['service'] = __('Service', 'cmsmasters');
	
	return $tabs;
}


function cmsms_options_services_sections() {
	$tab = cmsms_get_the_tab();
	
	switch ($tab) {
	case 's_page':
		$sections = array();
		
		$sections['s_page_section'] = __('Services Page Options', 'cmsmasters');
		
		break;
	case 'service':
		$sections = array();
		
		$sections['service_section'] = __('Services Post Options', 'cmsmasters');
		
		break;
	}
	
	return $sections;
} 


function cmsms_options_services_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = cmsms_get_the_tab();
	}
	
	$options = array();
	
	switch ($tab) {
	case 's_page':
		$options[] = array( 
			'section' => 's_page_section', 
			'id' => CMSMS_SHORTNAME . '_services_page_title', 
			'title' => __('Service Title', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 's_page_section', 
			'id' => CMSMS_SHORTNAME . '_services_page_descr', 
			'title' => __('Service Description', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 's_page_section', 
			'id' => CMSMS_SHORTNAME . '_services_page_cat', 
			'title' => __('Service Categories', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		break;
	case 'service':
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_title', 
			'title' => __('Service Title', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_date', 
			'title' => __('Service Date', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_cat', 
			'title' => __('Service Categories', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_author', 
			'title' => __('Service Author', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_comment', 
			'title' => __('Service Comments', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_like', 
			'title' => __('Like Box', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_tag', 
			'title' => __('Service Tags', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_nav_box', 
			'title' => __('Service Navigation Box', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_share_box', 
			'title' => __('Sharing Box', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_author_box', 
			'title' => __('About Author Box', 'cmsmasters'), 
			'desc' => __('show', 'cmsmasters'), 
			'type' => 'checkbox', 
			'std' => 1 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_more_posts_box', 
			'title' => __('More Services Box', 'cmsmasters'), 
			'desc' => '', 
			'type' => 'multi-checkbox', 
			'std' => array( 
				'related' => 'true', 
				'popular' => 'true', 
				'recent' => 'true' 
			), 
			'choices' => array( 
				__('Show Related Tab', 'cmsmasters') . '|related', 
				__('Show Popular Tab', 'cmsmasters') . '|popular', 
				__('Show Recent Tab', 'cmsmasters') . '|recent' 
			) 
		);
		
		$options[] = array( 
			'section' => 'service_section', 
			'id' => CMSMS_SHORTNAME . '_services_post_r_p_l_number', 
			'title' => __('Related, Popular & Latest Services Boxes Items Number', 'cmsmasters'), 
			'desc' => __('services', 'cmsmasters'), 
			'type' => 'number', 
			'std' => '4' 
		);
		
		break;
	}
	
	return $options;	
}

